<?php
// fetch_tmdb_search.php
// Este script recebe a query de busca do JavaScript e faz a requisição à API do TMDB.

header('Content-Type: application/json'); // Garante que a resposta seja JSON

$api_key = '2557fea3b40cbbd5a65e12422d017de1'; // Sua API Key do TMDB
$query = $_GET['query'] ?? '';

if (empty($query)) {
    echo json_encode(['error' => 'Query de busca vazia.']);
    exit;
}

// Endpoint de busca multi (filmes e séries) no TMDB
$url = "https://api.themoviedb.org/3/search/multi?api_key={$api_key}&language=pt-BR&query=" . urlencode($query);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['error' => 'Erro cURL:' . curl_error($ch)]);
    exit;
}

curl_close($ch);

// Retorna a resposta JSON diretamente para o JavaScript
echo $response;
?>